/** @file   PathFinderAlgo.cpp
 * @brief   Implementation of pathfinding interfaces and baseclasses.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/02/21 20:48:11 $
 * @author  Tomi Lamminsaari
 */

#include "PathFinderAlgo.h"


namespace eng2d {

///
/// PathNode class
/// ==============

PathNode::PathNode() :
  iPosition( 0,0 ),
  iParentPosition( 0,0 ),
  iGone( 0 ),
  iHeuristic( 0 ),
  iTotalCost( 0 )
{
}

PathNode::PathNode( const Vec2D& aPos ) :
  iPosition( aPos ),
  iParentPosition( 0,0 ),
  iGone( 0 ),
  iHeuristic( 0 ),
  iTotalCost( 0 )
{
}

PathNode::~PathNode()
{
}

bool PathNode::operator < ( const PathNode& aAnother ) const
{
  return static_cast<bool>( iTotalCost < aAnother.iTotalCost );
}

bool PathNode::operator > ( const PathNode& aAnother ) const
{
  return static_cast<bool>( iTotalCost > aAnother.iTotalCost );
}

};  // end of namespace
